//
//  $Id: AHKMMainWindowController.m 98 2009-06-12 17:01:44Z fujidana $
//  Copyright (c) 2005-2009 Fujidana All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "AHKMMainWindowController.h"
#import "AHKMArrayController.h"
#import <AddressBook/AddressBook.h>
#import "AHKShortTimeDateValueTransformer.h"


NSString* AHKMPhoneNumberDefaultsKey      = @"AHKLightMailUsersPhoneNumber";
NSString* AHKMFileFormatDefaultsKey       = @"AHKMFileFormat";
// NSString* AHKMDefaultsLastSentDateKey     = @"AHKMLastSentDate";
NSString* AHKMDefaultsLastReceivedDateKey = @"AHKMLastReceivedDate";


@implementation AHKMMainWindowController

+ (void)initialize
{
    NSUserDefaults *userDefaults          = [NSUserDefaults standardUserDefaults];
    NSDictionary   *regstrationDictionary = [NSDictionary dictionaryWithObjectsAndKeys:
											 // @"", AHKMEmailAddressUserDefaultsKey, 
											 @"07000000000", AHKMPhoneNumberDefaultsKey, 
											 [NSNumber numberWithInt:0], AHKMFileFormatDefaultsKey,
											 // [NSNull null], AHKMDefaultsLastSentDateKey, 
											 // [NSNull null], AHKMDefaultsLastReceivedDateKey, 
											 nil];
    [userDefaults registerDefaults:regstrationDictionary];
	
	// -- set custom value transformer --
	AHKShortTimeDateValueTransformer *shortTimeDateValueTransformer = [[AHKShortTimeDateValueTransformer alloc] init];
	[NSValueTransformer setValueTransformer:shortTimeDateValueTransformer
									forName:@"AHKShortTimeDate"];
	[shortTimeDateValueTransformer release];
}

#pragma mark init/dealloc methods

- (id)init
{
	self = [super initWithWindowNibName:@"AHKMMainWindow"];
	if (self != nil)
	{
		[self setWindowFrameAutosaveName:@"AHKMMainWindow"];
		[[self window] setExcludedFromWindowsMenu:YES];
		[self showWindow:nil];
		
		[[NSNotificationCenter defaultCenter] addObserver:self
												 selector:@selector(windowWillClose:)
													 name:@"NSWindowWillCloseNotification"
												   object:[self window]];
	}
	return self;
}

- (void)windowDidLoad
{
	[super windowDidLoad];
	
	if ([self loadDefaultDatabase] == NO)
	{
		// do error handling in future...
		[self setMails:[NSArray array]];
	}
	
	[mailsController bind:@"contentArray" 
				 toObject:self 
			  withKeyPath:@"mails" 
				  options:[NSDictionary dictionaryWithObjectsAndKeys:[NSNumber numberWithBool:YES], @"NSRaisesForNotApplicableKeys", [NSNumber numberWithBool:YES], @"NSConditionallySetsEditable", nil]];
	
	// -- set toolbar --
	[self setupToolbar];
}

// 
- (void)windowWillClose:(NSNotification *)aNotification
{
	[[self window] makeFirstResponder:nil];
	
	// Save defaults and close the drawer when the window is closed, because the delegate method
	// applicationShouldTerminateAfterLastWindowClosed: does not work when the last window is closed 
	// with its drawer remained open.
	// if applicationShouldTerminateAfterLastWindowClosed: becomes to work with the drawer remained open,
	// the following code will be moved to applicationWillTerminate:
	
	if ([self storeDefaultDatabase] == NO)
	{
		// do error handling in future...
	}
	
	[[NSUserDefaults standardUserDefaults] synchronize];
}

- (void)dealloc
{
	[self setMails:nil];
	
	[super dealloc];
}

#pragma mark accessor methods
- (NSArray *)mails
{
	return _mails;
}

- (void)setMails:(NSArray *)value
{
	if (_mails != value)
	{
		[_mails release];
		_mails = [value copy];
	}
}


#pragma mark implements NSMenuValidation
- (BOOL)validateMenuItem:(id <NSMenuItem>)menuItem
{
	if ([menuItem action] == @selector(showWindow:))
	{
		if ([[self window] isKeyWindow])
		{
			[menuItem setState:NSOnState];
		}
		else
		{
			[menuItem setState:NSOffState];
		}
	}
	else if ([menuItem action] == @selector(exportSelection:))
	{
		return ([[mailsController selectedObjects] count] > 0);
	} 
	else if ([menuItem action] == @selector(selectNext:))
	{
		return [mailsController canSelectNext];
	}
	else if ([menuItem action] == @selector(selectPrevious:))
	{
		return [mailsController canSelectPrevious];
	}
	return YES;
}


#pragma mark IBActions and their delegation methods
- (IBAction)selectNext:(id)sender
{
	[mailsController selectNext:sender];
}

- (IBAction)selectPrevious:(id)sender
{
	[mailsController selectPrevious:sender];
}

- (IBAction)guess:(id)sender
{
	[[self window] makeFirstResponder:nil];
	ABPerson *me = [[ABAddressBook sharedAddressBook] me];
	if (me)
	{
		ABMultiValue *phoneNumbers = [me valueForProperty:kABPhoneProperty];
		NSString *string, *substring;
		int i;
		
		for (i = 0; i < [phoneNumbers count]; i++)
		{
			string = [phoneNumbers valueAtIndex:i];
			if ([string length] >= 10)
			{
				substring = [string substringToIndex:3];
				if ([substring isEqualToString:@"070"])
				{
					int     length = [string length];
					unichar c;
					unichar convertedChar[length];
					int     j, k = 0;
					
					for (j = 0; j < length; j++)
					{
						c = [string characterAtIndex:j];
						// if c is a numeric character ('0--9')
						if (c >= 0x0030 && c <= 0x0039)
						{
							convertedChar[k] = c;
							k++;
						}
					}
					string = [NSString stringWithCharacters:convertedChar length:k];
					
					//[phoneNumberTextField setStringValue:string];
					NSUserDefaults *userDefaults = [NSUserDefaults standardUserDefaults];
					[userDefaults setObject:string
									 forKey:AHKMPhoneNumberDefaultsKey];
					[userDefaults synchronize];
					break;
				}
			}
		}
	}
}

- (IBAction)showSelectedMailboxMails:(id)sender
{
	if ([sender respondsToSelector:@selector(selectedSegment)])
	{
		switch ([sender selectedSegment])
		{
			case 0:
				[self showAllMails:sender]; break;
			case 1:
				[self showInboxMails:sender]; break;
			case 2: 
				[self showOutboxMails:sender]; break;
		}
	}
}

- (IBAction)showAllMails:(id)sender
{
	[[objectTableColumn headerCell] setStringValue:NSLocalizedStringFromTable(@"Object", @"AHKMLocalizable", @"mainTableView.objectHeaderCell.objectTitle")];
	[mailsController setMailboxToBeShown:0];
}

- (IBAction)showInboxMails:(id)sender
{
	[[objectTableColumn headerCell] setStringValue:NSLocalizedStringFromTable(@"From", @"AHKMLocalizable", @"mainTableView.objectHeaderCell.From")];
	[mailsController setMailboxToBeShown:1];
}

- (IBAction)showOutboxMails:(id)sender
{
	[[objectTableColumn headerCell] setStringValue:NSLocalizedStringFromTable(@"To", @"AHKMLocalizable", @"mainTableView.objectHeaderCell.To")];
	[mailsController setMailboxToBeShown:2];
}

#pragma mark other methods
- (NSArray *)mailBoxLabels
{
	return [NSArray arrayWithObjects:@"Unknown", @"Sent", @"Draft", @"Inbox", nil];
}

@end
